# Proposal for PyGotham 2019 talk

https://cfp.pygotham.org/talks/new


## Title

A framework for domain specific languages in Python

## Description


We love Python because of its simple and pleasant APIs.
However, we often need to rely on lower level languages
for efficient computation on large datasets. We often leak details
of these underlying routines to the APIs we provide to users, which
makes it hard to change them later.

What if we could instead separate the semantics of the users expectations
from the implementation details of how it executes? 


## Outline

* Overview of motivation
    * New hardware (GPU, TPU, asic) and execution paradigm (distributed, polyhedral compilation)
    * Fragmented array ecosystem (Tensorflow, PyTorch, Tensor Comprehensions, numexpr)
        * Requires reimplementing optimizations on all backends
        * Requires end user libraries (like scikit-learn) to support all backends
        * Different APIs for users to learn
        * Hard to collaborate
    * Need to provide users with some sort of API that they can target, agnostic of optimizations and backends
    * Quick overview of Mathematics of Arrays, how this helps translate high level array expresions into low level ones
    * So we are looking for a system that we can represent these types of translations in, provide a NumPy like API,
      and target different backends
* Overview of metadsl, the resulting framework
   * Build up simple algebra of adding numbers and booleans
       * show how to write replacement and optimizations
   * give example of building graph from NumPy compatible API
   * Show how it can be optimized and executed
* Results
   * Show how far we are in covering backends and NP api
   * Show performance comparisons with pure numpy
 
 ## Audience Take-Aways
 
 The audience of this talk will come away with a new tool to use
 when they are building shared APIs where they want to abstract
 the user experience from the execution engine. They will
 learn how to implement performance improvements by writing replacement
 rules on their execution graph. They will see how having multiple
 different internal representations of their library allows greater
 collaboration and reuse.
 
 If they are writing applications that depend on high performance array computing
 they will also learn how they can keep their application agnostic from any particular
 framework and optimize their algorithms before they compute them.
